<?php

if (!defined('BOOTSTRAP')) {
    die('Access denied');
}

use Tygh\Registry;
use Tygh\Settings;

if ($_SERVER['REQUEST_METHOD'] == 'GET' and $mode == 'update'
    and $_REQUEST['addon'] == 'ethermailer') {

    fn_clear_cache();
    $ethermailer_api_key = fn_ethermailer_get_option('ethermailer_api_key');

    $connected = false;
    $error = false;
    $ethermailer_username = '';
    if($ethermailer_api_key != "") {
        $ethermailer_username = fn_ethermailer_connect();
        if($ethermailer_username !== NULL) {
            $connected = true;
        } else {
            $error = true;
        }
    }

    $view = Registry::get('view');
    $view->assign('ethermailer_username', $ethermailer_username);
    $view->assign('ethermailer_api_key', $ethermailer_api_key);
    $view->assign('ethermailer_connected', $connected);
    $view->assign('ethermailer_error', $error);
    $view->assign('ethermailerAppUrl', 'https://app.ethermailer.com');
    $view->assign('canSyncCscartLists', fn_ethermailer_can_sync_cscart_lists());

    $options = $view->getTemplateVars('options');
    if (isset($options['main'])) {
        unset($options['main']);
        $view->assign('options', $options);
    }

}
