<?php

if (!defined('BOOTSTRAP')) {
    die('Access denied');
}

use Tygh\Registry;

$view = Registry::get('view');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($mode == 'ethermailer_connect') {

        fn_clear_cache();
        fn_rm(Registry::get('config.dir.cache_templates'));

        $ethermailer_api_key = "";
        if(isset($_REQUEST['ethermailer_register']['api_key'])) {
            $ethermailer_api_key = trim($_REQUEST['ethermailer_register']['api_key']);
            fn_ethermailer_set_option('ethermailer_api_key', $ethermailer_api_key);
        }

        $connected = false;
        $error = false;
        $ethermailer_username = '';
        if($ethermailer_api_key != "") {
            $ethermailer_username = fn_ethermailer_connect();
            if($ethermailer_username !== NULL) {
                $connected = true;
            } else {
                $error = true;
            }
        }

        if (defined('AJAX_REQUEST')) {
            $view->assign('ethermailer_username', $ethermailer_username);
            $view->assign('ethermailer_api_key', $ethermailer_api_key);
            $view->assign('ethermailer_connected', $connected);
            $view->assign('ethermailer_error', $error);
            $view->assign('ethermailerAppUrl', 'https://app.ethermailer.com');
            $view->assign('canSyncCscartLists', fn_ethermailer_can_sync_cscart_lists());
            $view->display('addons/ethermailer/settings/connect.tpl');
            exit;
        }
        return array(CONTROLLER_STATUS_REDIRECT, 'addons.update&addon=ethermailer');
    }

} elseif (isset($_REQUEST['addon']) && $_REQUEST['addon'] == 'ethermailer') {
    if(isset($_REQUEST['reset'])) {
        fn_ethermailer_set_option('ethermailer_api_key', '');
        fn_clear_cache();
        return array(CONTROLLER_STATUS_REDIRECT, 'addons.update&addon=ethermailer');
    }
}
