<?php

if (!defined('BOOTSTRAP')) {
    die('Access denied');
}

use Tygh\Registry;

if(fn_ethermailer_is_addon_ready()) {
    $canSyncCscartLists = fn_ethermailer_can_sync_cscart_lists();
    if($mode == 'manage') {
        $view = Registry::get('view');
        $view->assign('ethermailerAppUrl', 'https://app.ethermailer.com');
        $view->assign('canSyncCscartLists', $canSyncCscartLists);
    } else if($mode == 'sync_contacts') {
        if(!$canSyncCscartLists) {
            return array(CONTROLLER_STATUS_REDIRECT, "ethermailer.manage");
        }
        if($_SERVER['REQUEST_METHOD'] == 'POST') {
            $importResult = fn_ethermailer_sync_lists($_REQUEST['cscart_list']);
            if (defined('AJAX_REQUEST')) {
                $view = Registry::get('view');
                $view->assign('importResult', $importResult);
                $view->display('addons/ethermailer/views/ethermailer/sync_contacts_results.tpl');
                exit;
            }
        } else {
            $view = Registry::get('view');
            $view->assign('cscartLists', fn_ethermailer_get_cscart_lists());
            $view->assign('ethermailerLists', fn_ethermailer_get_lists());
        }
    } else if($mode == 'checkout_settings') {
        if($_SERVER['REQUEST_METHOD'] == 'POST') {
            if (defined('AJAX_REQUEST')) {
                $ethermailerListsToSet = array();
                $ethermailerSenderProfileToSet = null;
                $ethermailerActivationUrl = '';
                if(isset($_REQUEST['ethermailer_lists'])) {
                    $ethermailerListsToSet = $_REQUEST['ethermailer_lists'];
                }
                if(isset($_REQUEST['ethermailer_sender_profile'])) {
                    $ethermailerSenderProfileToSet = $_REQUEST['ethermailer_sender_profile'];
                }
                if(isset($_REQUEST['ethermailer_activation_url'])) {
                    $ethermailerActivationUrl = $_REQUEST['ethermailer_activation_url'];
                }
                fn_ethermailer_save_lists_for_checkout_settings($ethermailerListsToSet, $ethermailerSenderProfileToSet, $ethermailerActivationUrl);
                $view = Registry::get('view');
                $view->display('addons/ethermailer/views/ethermailer/checkout_settings_results.tpl');
                exit;
            }
        } else {
            $view = Registry::get('view');
            $view->assign('ethermailerLists', fn_ethermailer_get_lists_for_checkout_settings());
            $view->assign('ethermailerSenderProfiles', fn_ethermailer_get_sender_profiles_for_checkout_settings());
            $view->assign('ethermailerActivationUrl', fn_ethermailer_get_checkout_activation_url());
        }
    }
} else {
    return array(CONTROLLER_STATUS_REDIRECT, "addons.update&addon=ethermailer");
}