<?php


if (!defined('BOOTSTRAP')) {
    die('Access denied');
}

use Tygh\Settings;
use Tygh\Registry;

require_once 'libs/ethermailer_api.php';

function fn_ethermailer_set_option($optionName, $optionValue) {
    if (!$section = Settings::instance()->getSectionByName('ethermailer', Settings::ADDON_SECTION)) {
        $section = Settings::instance()->updateSection(array(
            'parent_id' =>      0,
            'edition_type' =>   'ROOT',
            'name' =>           'ethermailer',
            'type' =>           Settings::ADDON_SECTION
        ));
    }

    if (!$setting_id = Settings::instance()->getId($optionName,'ethermailer')) {
        $setting_id = Settings::instance()->update(array(
            'name' =>           $optionName,
            'section_id' =>     $section['section_id'],
            'edition_type' =>   'ROOT',
            'section_tab_id' => 0,
            'type' =>           'A',
            'position' =>       0,
            'is_global' =>      'N',
            'handler' =>        ''
        ), null, null, true);
    }
    Settings::instance()->updateValueById($setting_id, $optionValue);
}

function fn_ethermailer_get_option($optionName) {
    return Settings::instance()->getValue($optionName, 'ethermailer');;
}

/**
 * @return EtherMailerApi
 */
function fn_ethermailer_get_ethermailerapiinstance() {
    $ethermailer_api_key = fn_ethermailer_get_option('ethermailer_api_key');
    return EtherMailerApi::instance($ethermailer_api_key);
}

/**
 * @return null|string
 */
function fn_ethermailer_connect() {
    return fn_ethermailer_get_ethermailerapiinstance()->getUsername();
}

/**
 * @return boolean
 */
function fn_ethermailer_is_addon_ready() {
    $username = fn_ethermailer_get_ethermailerapiinstance()->getUsername();
    if($username == null) {
        return false;
    }
    return true;
}

/**
 * @return bool
 */
function fn_ethermailer_can_sync_cscart_lists() {
    return function_exists('fn_get_mailing_lists');
}

function fn_ethermailer_get_lists_for_block() {
    $paginationPojo = fn_ethermailer_get_ethermailerapiinstance()->getGroups();
    $groups = array();
    foreach($paginationPojo->items as $contactGroup) {
        /* @var $contactGroup ContactGroup */
        $groups[$contactGroup->groupId] = $contactGroup->name;
        unset($contactGroup);
    }
    return $groups;
}

function fn_ethermailer_get_sender_profiles_for_block() {
    $listPojo = fn_ethermailer_get_ethermailerapiinstance()->getSenderProfiles();
    $senders = array();
    foreach($listPojo->items as $senderProfile) {
        /* @var $senderProfile SenderProfile */
        if($senderProfile->verified) {
            $senders[$senderProfile->id] = $senderProfile->name.' ('.$senderProfile->email.')';
        }
    }
    return $senders;
}

function fn_ethermailer_get_lists_for_checkout_settings() {
    $lists = array();
    $enabledLists = fn_ethermailer_get_option('checkoutLists');
    if($enabledLists == null) {
        $enabledLists = array();
    }
    $paginationPojo = fn_ethermailer_get_ethermailerapiinstance()->getGroups();
    foreach($paginationPojo->items as $contactGroup) {
        /* @var $contactGroup ContactGroup */
        $list = array();
        $list['id'] = $contactGroup->groupId;
        $list['name'] = $contactGroup->name;
        $list['enabled'] = false;
        if(array_key_exists($list['id'], $enabledLists)) {
            $list['enabled'] = true;
        }
        $lists[] = $list;
        unset($list);
        unset($contactGroup);
    }
    return $lists;
}

function fn_ethermailer_get_sender_profiles_for_checkout_settings() {
    $senderProfiles = array();
    $enabledSenderProfile = fn_ethermailer_get_option('senderProfile');
    $listPojo = fn_ethermailer_get_ethermailerapiinstance()->getSenderProfiles();
    foreach($listPojo->items as $senderProfileTemp) {
        /** @var $senderProfileTemp SenderProfile */
        if($senderProfileTemp->verified) {
            /* @var $senderProfileTemp SenderProfile */
            $senderProfile = array();
            $senderProfile['id'] = $senderProfileTemp->id;
            $senderProfile['name'] = $senderProfileTemp->name;
            $senderProfile['email'] = $senderProfileTemp->email;
            $senderProfile['enabled'] = false;
            if($senderProfile['id'] == $enabledSenderProfile) {
                $senderProfile['enabled'] = true;
            }
            $senderProfiles[] = $senderProfile;
        }
        unset($senderProfile);
        unset($senderProfileTemp);
    }
    
    return $senderProfiles;
}

function fn_ethermailer_save_lists_for_checkout_settings($ethermailerListsToSet, $ethermailerSenderProfileToSet, $ethermailerActivationUrl) {
    if($ethermailerListsToSet == null) {
        $ethermailerListsToSet = array();
    }
    if($ethermailerActivationUrl == null) {
        $ethermailerActivationUrl = '';
    }
    fn_ethermailer_set_option('checkoutLists', $ethermailerListsToSet);
    fn_ethermailer_set_option('senderProfile', $ethermailerSenderProfileToSet);
    fn_ethermailer_set_option('checkoutActivationUrl', $ethermailerActivationUrl);
}

function fn_ethermailer_get_lists_for_checkout() {
    $lists = array();
    $enabledLists = fn_ethermailer_get_option('checkoutLists');
    if($enabledLists == null) {
        $enabledLists = array();
    }
    $paginationPojo = fn_ethermailer_get_ethermailerapiinstance()->getGroups();
    foreach($paginationPojo->items as $contactGroup) {
        /* @var $contactGroup ContactGroup */
        if(array_key_exists($contactGroup->groupId, $enabledLists)) {
            $list = array();
            $list['id'] = $contactGroup->groupId;
            $list['name'] = $contactGroup->name;
            $lists[] = $list;
        }
        unset($list);
        unset($contactGroup);
    }
    return $lists;
}

function fn_ethermailer_get_checkout_activation_url() {
    return fn_ethermailer_get_option('checkoutActivationUrl');
}

function fn_ethermailer_get_checkout_sender_profile() {
    return fn_ethermailer_get_option('senderProfile');
}

function fn_ethermailer_get_lists() {
    $lists = array();
    $paginationPojo = fn_ethermailer_get_ethermailerapiinstance()->getGroups();
    foreach($paginationPojo->items as $contactGroup) {
        /* @var $contactGroup ContactGroup */
        $list = array();
        $list['id'] = $contactGroup->groupId;
        $list['name'] = $contactGroup->name;
        $lists[] = $list;
        unset($list);
        unset($contactGroup);
    }
    return $lists;
}

function fn_ethermailer_get_contact_fields_for_block() {
    $paginationPojo = fn_ethermailer_get_ethermailerapiinstance()->getContactFields();
    $fields = array();
    $fields['name|||'.__('contact_name')] = __('contact_name');
    $fields['surname|||'.__('contact_surname')] = __('contact_surname');
    foreach($paginationPojo->items as $extraField) {
        /* @var $extraField ExtraField */
        if($extraField->type == ExtraField::TYPE_TEXT) {
            $fields['extraFieldValues.'.$extraField->fieldId.'|||'.$extraField->name] = $extraField->name;
        }
        unset($extraField);
    }
    return $fields;
}

/**
 * @param $ethermailerInstance EtherMailerApi
 * @return array
 */
function fn_ethermailer_get_contact_fields($ethermailerInstance) {
    $paginationPojo = $ethermailerInstance->getContactFields();
    $fields = array();
    foreach($paginationPojo->items as $extraField) {
        /* @var $extraField ExtraField */
        $fields[] = $extraField->fieldId;
        unset($extraField);
    }
    return $fields;
}

/**
 * @return array
 */
function fn_ethermailer_get_cscart_lists() {
    $lists = array();
    $cscart_lists = fn_get_mailing_lists();
    if($cscart_lists != null) {
        $cscart_lists = $cscart_lists[0];
        if($cscart_lists != null) {
            foreach($cscart_lists as $cscart_list) {
                $list = array();
                $list['id'] = $cscart_list['list_id'];
                $list['name'] = $cscart_list['object'];
                $lists[] = $list;
                unset($list);
                unset($cscart_list);
            }
        }
    }
    unset($cscart_lists);
    return $lists;
}

/**
 * @param $lists
 * @return array
 */
function fn_ethermailer_sync_lists($lists) {
    $importResult = array();
    $importResult['created'] = 0;
    $importResult['updated'] = 0;
    $importResult['errors'] = 0;
    if($lists != null) {
        set_time_limit(0);
        $ethermailerApiInstance = fn_ethermailer_get_ethermailerapiinstance();
        foreach($lists as $cscartListId => $ethermailerListId) {
            if($cscartListId != null && $ethermailerListId != null) {
                $joinLists = db_quote(" LEFT JOIN ?:user_mailing_lists ON ?:user_mailing_lists.subscriber_id = ?:subscribers.subscriber_id");
                $condition = '';
                $condition .= db_quote(" AND ?:user_mailing_lists.list_id = ?i", $cscartListId);
                $condition .= db_quote(" AND ?:user_mailing_lists.confirmed = ?i", 1);
                $cscart_total_subscribers = db_get_field("SELECT COUNT(DISTINCT(?:subscribers.subscriber_id)) FROM ?:subscribers $joinLists WHERE 1 $condition");;
                $itemsPerPage = 100;
                $totalPages = ceil($cscart_total_subscribers/$itemsPerPage);
                
                for($page=1; $page <= $totalPages; $page++) {
                    $limit = db_paginate($page, $itemsPerPage);
                    $subscribers = db_get_array("SELECT ?:subscribers.subscriber_id, ?:subscribers.email FROM ?:subscribers $joinLists WHERE 1 $condition GROUP BY ?:subscribers.subscriber_id $limit");

                    if(!empty($subscribers)) {
                        $contactImportList = array();
                        foreach($subscribers as $subscriber) {

                            $group = new ContactGroupPost();
                            $group->groupId = $ethermailerListId;
                            
                            $contact = new ContactPost();
                            $contact->email = $subscriber['email'];                            
                            $contact->groups = array();
                            $contact->groups[] = $group;
                            $contact->extraFieldValues = array();
                            
                            $contactImportList[] = $contact;
                            unset($subscriber);
                            unset($contact);
                        }
                        if(!empty($contactImportList)) {
                            $contactImportResponseList = $ethermailerApiInstance->importContacts($contactImportList);
                            $importResult['created'] = $importResult['created'] + $contactImportResponseList->totalCreated;
                            $importResult['updated'] = $importResult['updated'] + $contactImportResponseList->totalUpdated;
                            $importResult['errors'] = $importResult['errors'] + $contactImportResponseList->totalErrors;
                        }
                        unset($contactImportList);
                    }
                    unset($subscribers);
                }
            }
        }
        
    }
    return $importResult;
}

function fn_ethermailer_subsribe($request) {
    if($request != null) {
        $ethermailerApiInstance = fn_ethermailer_get_ethermailerapiinstance();

        $contactRegister = new ContactRegister();
        $contactRegister->name = '';
        if(isset($request['name'])) {
            $contactRegister->name = $request['name'];
        }
        $contactRegister->surname = '';
        if(isset($request['surname'])) {
            $contactRegister->surname = $request['surname'];
        }
        $contactRegister->email = $request['email'];
        
        $contactGroups = array();
        foreach ($request['groups'] as $group) {
            $contactGroup = new ContactGroupPost();
            $contactGroup->groupId = $group;
            $contactGroups[] = $contactGroup;
            unset($contactGroup);
        }
        $contactRegister->groups = $contactGroups;
        $contactRegister->senderProfileId = $request['sender_profile'];
        $contactRegister->urlRedirect = $request['url_activation'];

        $extraFieldValues = array();
        foreach($request as $reqId => $reqValue) {
            if(substr($reqId, 0, 17) == 'extraFieldValues_') {
                $extraFieldValue = new ExtraFieldValuePost();
                $extraFieldValue->fieldId = substr($reqId, 17);
                $extraFieldValue->value = $reqValue;
                $extraFieldValues[] = $extraFieldValue;
                unset($extraFieldValue);
            }
        }
        $contactRegister->extraFieldValues = $extraFieldValues;
        return $ethermailerApiInstance->registerContact($contactRegister);
    }
}

function fn_ethermailer_subscribe_email_to_lists($email, $groups, $senderProfile, $ethermailerActivationUrl) {
    if($email != null && $groups != null) {
        $ethermailerApiInstance = fn_ethermailer_get_ethermailerapiinstance();

        $contactRegister = new ContactRegister();
        $contactRegister->name = '';
        $contactRegister->surname = '';
        $contactRegister->email = $email;

        $contactGroups = array();
        foreach ($groups as $group) {
            $contactGroup = new ContactGroupPost();
            $contactGroup->groupId = $group;
            $contactGroups[] = $contactGroup;
            unset($contactGroup);
        }
        $contactRegister->groups = $contactGroups;
        $contactRegister->senderProfileId = $senderProfile;
        $contactRegister->urlRedirect = $ethermailerActivationUrl;
        $contactRegister->extraFieldValues = array();

        return $ethermailerApiInstance->registerContact($contactRegister);
    }
}