


{include file="common/subheader.tpl" title=__("ethermailer_connect_title")}


<div id="connect_settings">

    {if !$ethermailer_connected}
        {__("ethermailer_connect_register")}&nbsp;<a href="{$ethermailerAppUrl}/#/signup" target="_blank">Ether Mailer</a>
        <br/>
        <br/>
        {__("ethermailer_connect_must_provide_key")}
        <br/>
        <br/>
        <strong>{__("ethermailer_connect_instructions")}:</strong>
        <ol>
            <li><a href="{$ethermailerAppUrl}/#/login" target="_blank">{__("ethermailer_connect_instructions_1")}</a></li>
            <li>{__("ethermailer_connect_instructions_2")}</li>
            <li>{__("ethermailer_connect_instructions_3")}</li>
            <li>{__("ethermailer_connect_instructions_4")}</li>
            <li>{__("ethermailer_connect_instructions_5")}</li>
        </ol>
        {/if}

        <fieldset>
            <input type="hidden" name="result_ids" value="connect_settings" />

        {if !$ethermailer_connected}
        <div class="control-group {if $ethermailer_error}error{/if}">
            <label class="control-label cm-required" for="ethermailer_api_key">{__("ethermailer_connect_api_key")}:</label>
            <div class="controls">
                <input type="text" id="ethermailer_api_key" name="ethermailer_register[api_key]"  value="{$ethermailer_api_key}" class="span8"/>
                {if $ethermailer_error}
                    <span class="help-inline"><p>{__("ethermailer_connect_api_key_error")}</p></span>
                {/if}
            </div>
        </div>

        <div class="control-group">
            <div class="controls">
                {include file="buttons/button.tpl" but_role="submit" but_meta="btn-primary cm-ajax" but_name="dispatch[addons.ethermailer_connect]" but_text=__("ethermailer_connect_connect")}
            </div>
        </div>


    {else}

        <h4 class="subheader">{__("ethermailer_connect_welcome")} {$ethermailer_username}!</h4>

        <div class="control-group">
            <label class="control-label cm-required" for="ethermailer_api_key">{__("ethermailer_connect_api_key")}:</label>
            <div class="controls">
                <input type="text" id="ethermailer_api_key" name="ethermailer_register[api_key]" value="{$ethermailer_api_key}" class="span8" disabled="disabled"/>
                <span class="label-success label"><i class="icon-ok icon-white"></i></span>
                <p class="muted">{__("ethermailer_connect_use_other_key")}, <a href="{"addons.update?addon=ethermailer&reset=true"|fn_url}">{__("ethermailer_connect_click_here")}</a></p>
            </div>
        </div>
    {/if}

    </fieldset>


    {if $ethermailer_connected}
        {include file="buttons/button.tpl" but_role="action" but_href="{"ethermailer.checkout_settings"|fn_url}" but_text=__("ethermailer_checkout_settings")}
        <div>&nbsp;</div>
        {include file="buttons/button.tpl" but_role="action" but_href="{"block_manager.manage"|fn_url}" but_text=__("ethermailer_add_blocks")}
        <div>&nbsp;</div>
        {if $canSyncCscartLists}
            {include file="buttons/button.tpl" but_role="action" but_href="{"ethermailer.sync_contacts"|fn_url}" but_text=__("ethermailer_sync_contacts")}
            <div class="text-error">{__("ethermailer_recommend_disable")}</div>
            <div>&nbsp;</div>
        {/if}
        {include file="buttons/button.tpl" but_role="action" but_meta="btn-primary" but_href="{$ethermailerAppUrl}/#/login" but_target="_blank" but_text=__("ethermailer_go_to")}
    {/if}


<!--connect_settings--></div>



