{** block-description:ethermailer_block_simple **}
{if $addons.ethermailer && $block.properties.ethermailer_contact_groups|sizeof > 0}
    <div class="ty-footer-form-block">
        <form action="{""|fn_url}" method="post" name="subscribe_form">
            <input type="hidden" name="redirect_url" value="{$config.current_url}" />
            <input type="hidden" name="url_activation" value="{$block.properties.url_activation}" />
            {foreach from=$block.properties.ethermailer_contact_groups item="group"}
                <input type="hidden" name="groups[{$group}]" value="{$group}" />
            {/foreach}
            <input type="hidden" name="sender_profile" value="{$block.properties.ethermailer_sender_profile}" />
            <h3 class="ty-footer-form-block__title">{$block.name}</h3>
            <div class="ty-footer-form-block__form ty-control-group ty-input-append">
                {assign var="onlyEmail" value=true}
                {foreach from=$block.properties.ethermailer_extra_contact_fields item="field"}
                    {assign var="onlyEmail" value=false}
                    {assign var="fieldSegments" value="|||"|explode:$field}
                    {assign var="fieldId" value=$fieldSegments.0}
                    {assign var="fieldDescription" value=$fieldSegments.1}
                    <div style="padding-bottom: 5px">
                        <label class="hidden" for="{$fieldId}{$block.block_id}">{$fieldDescription}</label>
                        <input type="text" name="{$fieldId}" id="{$fieldId}{$block.block_id}" size="20" value="{$fieldDescription}" class="cm-hint ty-input-text" />
                    </div>
                {/foreach}
                <div>
                    <label class="cm-required cm-email hidden" for="email{$block.block_id}">{__("email")}</label>
                    <input type="text" name="email" id="email{$block.block_id}" size="20" value="{__("enter_email")}" class="cm-hint ty-input-text" />
                    {if $onlyEmail}
                        {include file="buttons/go.tpl" but_name="ethermailer.add_subscriber" alt=__("ethermailer_subscribe")}
                    {/if}
                </div>
                {if !$onlyEmail}
                    <div style="padding-top: 5px">
                        <button class="ty-btn__primary ty-btn__big ty-btn__add-to-cart ty-btn" name="dispatch[ethermailer.add_subscriber]" type="submit">{__("ethermailer_subscribe")}</button>
                    </div>
                {/if}
            </div>
        </form>
    </div>
{/if}